/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import xfacthd.framedblocks.api.shapes.ShapeReloader;

public final class ShapeCache<K> {
    private final Supplier<Map<K, VoxelShape>> mapFactory;
    private final Consumer<Map<K, VoxelShape>> generator;
    private Map<K, VoxelShape> cache;

    @Deprecated(forRemoval=true)
    public ShapeCache(Consumer<Map<K, VoxelShape>> generator) {
        this(HashMap::new, generator);
    }

    @Deprecated(forRemoval=true)
    public ShapeCache(Map<K, VoxelShape> cache, Consumer<Map<K, VoxelShape>> generator) {
        this.mapFactory = null;
        this.generator = generator;
        this.cache = cache;
        generator.accept(cache);
        if (!FMLEnvironment.production) {
            ShapeReloader.addCache(this);
        }
    }

    private ShapeCache(Supplier<Map<K, VoxelShape>> mapFactory, Consumer<Map<K, VoxelShape>> generator) {
        this.mapFactory = mapFactory;
        this.generator = generator;
        this.cache = mapFactory.get();
        generator.accept(this.cache);
        if (!FMLEnvironment.production) {
            ShapeReloader.addCache(this);
        }
    }

    public VoxelShape get(K key) {
        return this.cache.get(key);
    }

    public void forEach(BiConsumer<K, VoxelShape> consumer) {
        this.cache.forEach(consumer);
    }

    @ApiStatus.Internal
    public void reload() {
        Map<K, VoxelShape> map;
        if (this.mapFactory != null) {
            map = this.mapFactory.get();
        } else {
            map = this.cache;
            this.cache.clear();
        }
        this.generator.accept(map);
        this.cache = map;
    }

    public static <T> ShapeCache<T> create(Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(HashMap::new, generator);
    }

    public static <T> ShapeCache<T> createIdentity(Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(IdentityHashMap::new, generator);
    }

    public static <T extends Enum<T>> ShapeCache<T> createEnum(Class<T> enumClazz, Consumer<Map<T, VoxelShape>> generator) {
        return new ShapeCache(() -> new EnumMap(enumClazz), generator);
    }
}

